// Bubble.pde

class Bubble {
  PVector pos;  // 位置をベクトルで表す
  float vy, size;  // y方向のスピードとサイズ

  Bubble() {
    pos   = new PVector(random(width), height + random(20, 100));  // 乱数を使用してベクトルを作成
    vy = random(1, 3);
    size  = random(5, 15);
  }

  // 泡を上に動かす
  void rise() {
    pos.y -= vy;
  }

  // 画面外に行ったかどうかをチェック
  boolean isOffScreen() {
    return pos.y + size < 0;  // trueかfalseがリターンされる
  }

  // 泡の描画
  void display() {
    noFill();
    stroke(255, 200);
    strokeWeight(2);
    ellipse(pos.x, pos.y, size, size);  // 円で泡を描く
  }
}
