// Fish.pde

class Fish {
  PVector pos, vel;  // 位置と速度をベクトルで表す
  float size;
  color col;

  // コンストラクタ1: ランダム位置の場合
  Fish() {
    pos  = new PVector(random(width), random(height));  // 乱数を使用して位置のベクトルを作成
    vel  = PVector.random2D().mult(2);  // 乱数を使用して速度のベクトルを作成
    size = random(20, 40);
    col  = color(random(50, 255), random(50, 255), random(50, 255));
  }
  
  // コンストラクタ2: クリック位置の場合
  Fish(float x, float y) {
    pos  = new PVector(x, y);  // 位置のベクトルを作成
    vel  = PVector.random2D().mult(2);  // 乱数を使用して速度のベクトルを作成
    size = random(20, 40);
    col  = color(random(50, 255), random(50, 255), random(50, 255));
  }

  // 移動＆壁で跳ね返る
  void move() {
    pos.add(vel);
    if (pos.x < 0 || pos.x > width)  vel.x *= -1;  // x方向の速度の符号を変える
    if (pos.y < 0 || pos.y > height) vel.y *= -1;  // y方向の速度の符号を変える
    
    // ランダムに方向を少し変える
    if (random(1) < 0.01) {
      vel.rotate(radians(random(-30, 30)));
    }
  }

  // 魚の描画
  void display() {
    pushMatrix();
    translate(pos.x, pos.y);
    float angle = atan2(vel.y, vel.x);
    rotate(angle);
    noStroke();
    fill(col);
    // 楕円で体を描く
    ellipse(0, 0, size * 1.5, size);
    // 三角形で尾びれを描く
    triangle(-size*0.8, 0, -size*1.2, size*0.4, -size*1.2, -size*0.4);
    popMatrix();
  }
}
